#include <NearbusEther_v16.h>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
// NEARBUS LIBRARY - www.nearbus.net        
// Description: Hello World Example
// Platform:    Arduino Ethernet
// Status:      Alpha Release
// Author:      F. Depalma
// Support:     info@nearbus.net
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
// REVISION HISTORY
// v0.20 - 08-02-13 - Initial Release
// v0.21 - 25-04-13 - This release includes support for Arduino Mega 128 and 256 (ADC function)  - Contributor: Peter Huff.  
// v0.3L - 02-05-13 - This release implements 32bits Registers  for TRNSP mode (Reg_A & Reg_B) and support for Google Connector.
// v0.4L - 10-05-13 - This release includes support to: Ethernet, WiFi and GPRS Arduino shields.
// v0.5L - 29-06-13 - This release includes support for IP Static Addressing - Contributor: Craig.  
// v0.6  - 02-08-13 - This release implement DNS Address Resolution and PULSE_OUTPUT NearBIOS function.
// v0.7  - 20-08-13 - This release implements support for user defined functions (MY_NBIOS_0).
// v0.9  - 17-09-13 - This release implements Enhanced Services (Alpha) - TriggerInput() - DigitalCounter() - RmsInput() and ResetPort().
// v0.10 - 05-11-13 - This release implements support for Arduino YUN (it requires IDE 1.5.4) and fixes some minors bugs.
// v0.11 - 12-11-13 - This release fixes a BUG in the MY_NBIOS service.
// v0.12 - 28-11-13 - The RMS_INPUT service is modified to deliver a mV output value.
// v0.14 - 03-01-14 - This release Include supports for X-CONTROL.
// v0.15 - 11-01-14 - This release Include supports for X-CONTROL V2.
// v0.16 - 16-04-14 - This release fix a register debug bug.
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AGENT CONFIGURATION PARAMETERS  ( You only need to define these parameters )
// IMPORTANT: this agent version is only supported on devices ID from NB100246 onwards
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
//char deviceId []    = "agent_id";                              // Put here the device_ID generated by the NearHub ( NB1xxxxx )
char deviceId []    = "NB101083";
//char sharedSecret[] = "agent_password";                        // (IMPORTANT: mandatory 8 characters/numbers) - The same as you configured in the NearHu;
char sharedSecret[] = "12345678";
//byte mac[6]         = { 0x90, 0xA2, 0xDA, 0x0D, 0x21, 0xEA };  // Put here the Arduino's Ethernet MAC
byte mac[6]         = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };

// ADDITIONAL CONFIGURATION FOR STATIC IP ADDRESSING
#define  STATIC_IP  0                                          // 1=>Static IP  0=>DHCP
byte ip[]           = { 192,168,1,10 };                        // Your Arduino IP Address
byte subnet[]       = { 255,255,255,0 };                       // Your Arduino IP Mask
byte gateway[]      = { 192,168,1,1 };                         // Your Default Gateway (LAN Router)
byte gdns[]         = { 8,8,8,8 };                             // Google DNS server

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  


///////////////////////////////////////////////////////////////////////////////////////////
//  Includes
///////////////////////////////////////////////////////////////////////////////////////////
#include <Ethernet.h>                                               // Ether Specific Configuration
#include <NearbusEther_v16.h> 	 									// [REL]	 
#include <SPI.h>
#include <Servo.h>
#include <FlexiTimer2.h>

///////////////////////////////////////////////////////////////////////////////////////////
//  Global Variables               
/////////////////////////////////////////////////////////////////////////////////////////// 
Nearbus Agent(0);

ULONG A_register[8];                                                // Define the Tx Buffer (Reg_A)
ULONG B_register[8];                                                // Define the Rx Buffer (Reg_B) 
int retorno;

void AuxPortServices(void) {
    Agent.PortServices(); 
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
//  BROWSER API REST COMMAND LINE (for JavaScript) - (use it for troubleshooting)
//
//  http://nearbus.net/v1/api_vmcu_jsb/NB100***?user=****&pass=****&channel=0&service=DIG_OUTPUT&value=1&method=POST&reqid=123456
//
//  user:          Your NearBus Web user
//  pass:          Your NearBus Web password
//  channel:       NearBus channel [0-3]
//  value:         Service value (if apply)
//  method:        GET (read) / POST (write)
//  reqid:        Transaction identifier (to match a request and its response)
// 
//  SUPPORTED API SERVICES
//  DIG_INPUT:     Digital Input - Input Range [0-1] - Method: GET 
//  DIG_OUTPUT:    Digital Output - Output Range [0-1] - Method: POST/GET 
//  ADC_INPUT:     ADC Analog Input - Output Range [0-1023] - Method: GET 
//  PULSE _OUTPUT: Digital Output - Input Range [0-65535] in steps of 10ms (max 655 seg) - Method: POST/GET 
//  PWM_OUTPUT:    PWM Output calibrated for Servomotors - Input Range [800-2200] - Method: POST/GET   
//  DIG_COUNTER:   Pulse Counter / Accumulator
//  RMS_INPUT:     True RMS Meter
//  MY_NBIOS_0:   User defined function
//
//  For a detailed information please go to: http://goo.gl/Gxrcua
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  


/*####################################################################################################################################
#######################################################################################################################################                                                                                                                                       ###
###          MY_NBIOS CUSTOM FUNCTION CODE                                                                                        ####                                                                                                     ###                                                                                                                               ###
#######################################################################################################################################
 ####################################################################################################################################*/ 

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
//  MOISTURE SENSOR - EXAMPLE OF CUSTOM CODE
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Product Web: http://www.seeedstudio.com/depot/grove-moisture-sensor-p-955.html
//  Wiki: http://seeedstudio.com/wiki/Grove_-_Moisture_Sensor
//  Code Source: n/a
//  Technical Spec: Humidytly: 5% RH - 99% RH - Temperature -40°C - 80°C - Acuracy: 2% RH / 0.5°C
//  Support Shield: Base Shield V1.3 - Grove compatible - http://seeedstudio.com/depot/base-shield-v13-p-1378.html
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
void Nearbus::MyNbios_0( byte portId, ULONG setValue, ULONG* pRetValue, byte vmcuMethod, PRT_CNTRL_STRCT* pPortControlStruct )
{
  
    //************************************
    // Reconfiguring Ports as I/O
    //************************************
    if( pPortControlStruct->portMode != MYNBIOS_MODE ) 
    {
	    PortModeConfig( portId, MYNBIOS_MODE );        
    }

    //************************************
    // Custom Function
    //************************************
    // DEFAULT:      The default analog reference of 5 volts (on 5V Arduino boards) or 3.3 volts (on 3.3V Arduino boards)
    // INTERNAL:     An built-in reference, equal to 1.1 volts on the ATmega168 or ATmega328 and 2.56 volts on the ATmega8 (not available on the Arduino Mega)
    // INTERNAL1V1:  A built-in 1.1V reference (Arduino Mega only)
    // INTERNAL2V56: A built-in 2.56V reference (Arduino Mega only)
    // EXTERNAL:     The voltage applied to the AREF pin (0 to 5V only) is used as the reference. 	
	
	
    analogReference( DEFAULT );	
       
    *pRetValue = (ULONG) analogRead( pPortControlStruct->anaPinId );   
  
}



/*####################################################################################################################################
#######################################################################################################################################
###          END OF CUSTOM CODE                                                                                                    ####                                                                                                     ###
#######################################################################################################################################
 ####################################################################################################################################*/ 

 

////////////////////////////////////////////////////////////////////// 
//   SETUP ROUTINE                                                                                 
//////////////////////////////////////////////////////////////////////                            
void setup(void)
{
         
    //*********************************
    // SERIAL INTERFACE INITIALIZATION
    //*********************************
    Serial.begin(9600);                                           // Start serial library
 
    //*********************************
    // NEARBUS INITIALIZATION
    //*********************************  
    Agent.NearInit( deviceId, sharedSecret );
  
    //*********************************
    // ETHERNET INITIALIZATION
    //*********************************   
    if( STATIC_IP ){
        Ethernet.begin( mac, ip, gdns, gateway, subnet );
    }  
    else {    
        Ethernet.begin( mac );
    }

    //*********************************
    // FLEXITIMER INITIALIZATION
    //*********************************
	#if FLEXI_TIMER		
	    FlexiTimer2::set( INT_PERIOD, AuxPortServices );          // Call the port services routine every 10 ms
        FlexiTimer2::start();
	#endif   
    
	delay(1000);                                                  // Give the Ethernet shield a second to initialize

    pinMode(3, OUTPUT);   
}

void loop()
{
int ret; 
        
    Agent.NearChannel( A_register, B_register, &ret );

    if ( ret >= 50 )
    {
        Serial.println( "Rx Error" ); 
        // [50]  Frame Autentication Mismatch
        // [51]  Frame Out of sequence
        // [52]  Remote ACK Error
        // [53]  Unsupported Command    
    }

/*
    ///////////////////////////////////
    // Example 1 - Analog Input        
    // Mode: TRNSP
    ///////////////////////////////////        
    A_register[0] = analogRead(0);                                // PIN A0
*/        

/* 
    ///////////////////////////////////
    // Example 2 - Digital Output
    // Mode: TRNSP
    ///////////////////////////////////        
    if( B_register[0] == 1 ){ 
        digitalWrite( 3, HIGH );                                  // PIN D3
    }
    else {
        digitalWrite( 3, LOW );                                   // PIN D3
    }
*/


/*        
    ///////////////////////////////////
    // Example 3 - PWM Analog Output
    // Mode: TRNSP
    ///////////////////////////////////                
    analogWrite( 3, B_register[0] );                              // PIN D3 - This function DO NOT works with Servo Motors and require an input from 0 to 255.
*/

}
